package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters._
sealed trait InstanceType {
  def unwrap: software.amazon.awssdk.services.codecatalyst.model.InstanceType
}
object InstanceType {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.InstanceType
  ): zio.aws.codecatalyst.model.InstanceType = value match {
    case software.amazon.awssdk.services.codecatalyst.model.InstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_SMALL =>
      val r = `dev.standard1.small`
      r
    case software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_MEDIUM =>
      val r = `dev.standard1.medium`
      r
    case software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_LARGE =>
      val r = `dev.standard1.large`
      r
    case software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_XLARGE =>
      val r = `dev.standard1.xlarge`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecatalyst.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.InstanceType =
      software.amazon.awssdk.services.codecatalyst.model.InstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `dev.standard1.small`
      extends zio.aws.codecatalyst.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.InstanceType =
      software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_SMALL
  }
  case object `dev.standard1.medium`
      extends zio.aws.codecatalyst.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.InstanceType =
      software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_MEDIUM
  }
  case object `dev.standard1.large`
      extends zio.aws.codecatalyst.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.InstanceType =
      software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_LARGE
  }
  case object `dev.standard1.xlarge`
      extends zio.aws.codecatalyst.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.InstanceType =
      software.amazon.awssdk.services.codecatalyst.model.InstanceType.DEV_STANDARD1_XLARGE
  }
}
