package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserIdentity(
    userType: zio.aws.codecatalyst.model.UserType,
    principalId: String,
    userName: Optional[String] = Optional.Absent,
    awsAccountId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UserIdentity = {
    import UserIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UserIdentity
      .builder()
      .userType(userType.unwrap)
      .principalId(principalId: java.lang.String)
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(awsAccountId.map(value => value: java.lang.String))(
        _.awsAccountId
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.UserIdentity.ReadOnly =
    zio.aws.codecatalyst.model.UserIdentity.wrap(buildAwsValue())
}
object UserIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UserIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UserIdentity =
      zio.aws.codecatalyst.model.UserIdentity(
        userType,
        principalId,
        userName.map(value => value),
        awsAccountId.map(value => value)
      )
    def userType: zio.aws.codecatalyst.model.UserType
    def principalId: String
    def userName: Optional[String]
    def awsAccountId: Optional[String]
    def getUserType: ZIO[Any, Nothing, zio.aws.codecatalyst.model.UserType] =
      ZIO.succeed(userType)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getAwsAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UserIdentity
  ) extends zio.aws.codecatalyst.model.UserIdentity.ReadOnly {
    override val userType: zio.aws.codecatalyst.model.UserType =
      zio.aws.codecatalyst.model.UserType.wrap(impl.userType())
    override val principalId: String = impl.principalId(): String
    override val userName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => value: String)
    override val awsAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UserIdentity
  ): zio.aws.codecatalyst.model.UserIdentity.ReadOnly = new Wrapper(impl)
}
