package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSpaceResponse(
    name: NameString,
    displayName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceResponse = {
    import DeleteSpaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceResponse
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly =
    zio.aws.codecatalyst.model.DeleteSpaceResponse.wrap(buildAwsValue())
}
object DeleteSpaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DeleteSpaceResponse =
      zio.aws.codecatalyst.model
        .DeleteSpaceResponse(name, displayName.map(value => value))
    def name: NameString
    def displayName: Optional[String]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceResponse
  ) extends zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly {
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceResponse
  ): zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly = new Wrapper(impl)
}
