package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteProjectResponse(
    spaceName: NameString,
    name: NameString,
    displayName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DeleteProjectResponse = {
    import DeleteProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DeleteProjectResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly =
    zio.aws.codecatalyst.model.DeleteProjectResponse.wrap(buildAwsValue())
}
object DeleteProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DeleteProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DeleteProjectResponse =
      zio.aws.codecatalyst.model
        .DeleteProjectResponse(spaceName, name, displayName.map(value => value))
    def spaceName: NameString
    def name: NameString
    def displayName: Optional[String]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteProjectResponse
  ) extends zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteProjectResponse
  ): zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
