package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProjectResponse(
    spaceName: Optional[NameString] = Optional.Absent,
    name: Optional[NameString] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UpdateProjectResponse = {
    import UpdateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UpdateProjectResponse
      .builder()
      .optionallyWith(
        spaceName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.spaceName)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly =
    zio.aws.codecatalyst.model.UpdateProjectResponse.wrap(buildAwsValue())
}
object UpdateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UpdateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UpdateProjectResponse =
      zio.aws.codecatalyst.model.UpdateProjectResponse(
        spaceName.map(value => value),
        name.map(value => value),
        displayName.map(value => value),
        description.map(value => value)
      )
    def spaceName: Optional[NameString]
    def name: Optional[NameString]
    def displayName: Optional[String]
    def description: Optional[String]
    def getSpaceName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("spaceName", spaceName)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateProjectResponse
  ) extends zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly {
    override val spaceName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateProjectResponse
  ): zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
