package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{Uuid, NameString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDevEnvironmentSessionRequest(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    sessionConfiguration: zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest = {
    import StartDevEnvironmentSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .sessionConfiguration(sessionConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StartDevEnvironmentSessionRequest.ReadOnly =
    zio.aws.codecatalyst.model.StartDevEnvironmentSessionRequest
      .wrap(buildAwsValue())
}
object StartDevEnvironmentSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.StartDevEnvironmentSessionRequest =
      zio.aws.codecatalyst.model.StartDevEnvironmentSessionRequest(
        spaceName,
        projectName,
        id,
        sessionConfiguration.asEditable
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def sessionConfiguration
        : zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration.ReadOnly
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getSessionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration.ReadOnly
    ] = ZIO.succeed(sessionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest
  ) extends zio.aws.codecatalyst.model.StartDevEnvironmentSessionRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val sessionConfiguration
        : zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration.ReadOnly =
      zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration
        .wrap(impl.sessionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest
  ): zio.aws.codecatalyst.model.StartDevEnvironmentSessionRequest.ReadOnly =
    new Wrapper(impl)
}
