package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDevEnvironmentSessionsResponse(
    items: Iterable[zio.aws.codecatalyst.model.DevEnvironmentSessionSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse = {
    import ListDevEnvironmentSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse
      .wrap(buildAwsValue())
}
object ListDevEnvironmentSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse =
      zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items
        : List[zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse
  ) extends zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly {
    override val items: List[
      zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
    ] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse
  ): zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly =
    new Wrapper(impl)
}
