package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.VerifySessionResponseIdentityString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifySessionResponse(
    identity: Optional[VerifySessionResponseIdentityString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse = {
    import VerifySessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse
      .builder()
      .optionallyWith(
        identity.map(value =>
          VerifySessionResponseIdentityString.unwrap(value): java.lang.String
        )
      )(_.identity)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly =
    zio.aws.codecatalyst.model.VerifySessionResponse.wrap(buildAwsValue())
}
object VerifySessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.VerifySessionResponse =
      zio.aws.codecatalyst.model
        .VerifySessionResponse(identity.map(value => value))
    def identity: Optional[VerifySessionResponseIdentityString]
    def getIdentity: ZIO[Any, AwsError, VerifySessionResponseIdentityString] =
      AwsError.unwrapOptionField("identity", identity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse
  ) extends zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly {
    override val identity: Optional[VerifySessionResponseIdentityString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identity())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .VerifySessionResponseIdentityString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse
  ): zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
