package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  SourceRepositoryBranchString,
  SourceRepositoryNameString,
  NameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSourceRepositoryBranchRequest(
    spaceName: NameString,
    projectName: NameString,
    sourceRepositoryName: SourceRepositoryNameString,
    name: SourceRepositoryBranchString,
    headCommitId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest = {
    import CreateSourceRepositoryBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .sourceRepositoryName(
        SourceRepositoryNameString.unwrap(
          sourceRepositoryName
        ): java.lang.String
      )
      .name(SourceRepositoryBranchString.unwrap(name): java.lang.String)
      .optionallyWith(headCommitId.map(value => value: java.lang.String))(
        _.headCommitId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.CreateSourceRepositoryBranchRequest.ReadOnly =
    zio.aws.codecatalyst.model.CreateSourceRepositoryBranchRequest
      .wrap(buildAwsValue())
}
object CreateSourceRepositoryBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.CreateSourceRepositoryBranchRequest =
      zio.aws.codecatalyst.model.CreateSourceRepositoryBranchRequest(
        spaceName,
        projectName,
        sourceRepositoryName,
        name,
        headCommitId.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def sourceRepositoryName: SourceRepositoryNameString
    def name: SourceRepositoryBranchString
    def headCommitId: Optional[String]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getSourceRepositoryName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(sourceRepositoryName)
    def getName: ZIO[Any, Nothing, SourceRepositoryBranchString] =
      ZIO.succeed(name)
    def getHeadCommitId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("headCommitId", headCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
  ) extends zio.aws.codecatalyst.model.CreateSourceRepositoryBranchRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val sourceRepositoryName: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.sourceRepositoryName())
    override val name: SourceRepositoryBranchString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryBranchString(impl.name())
    override val headCommitId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.headCommitId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
  ): zio.aws.codecatalyst.model.CreateSourceRepositoryBranchRequest.ReadOnly =
    new Wrapper(impl)
}
