package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSpaceRequest(name: NameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest = {
    import GetSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetSpaceRequest.ReadOnly =
    zio.aws.codecatalyst.model.GetSpaceRequest.wrap(buildAwsValue())
}
object GetSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetSpaceRequest =
      zio.aws.codecatalyst.model.GetSpaceRequest(name)
    def name: NameString
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest
  ) extends zio.aws.codecatalyst.model.GetSpaceRequest.ReadOnly {
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest
  ): zio.aws.codecatalyst.model.GetSpaceRequest.ReadOnly = new Wrapper(impl)
}
