package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters._
sealed trait FilterKey {
  def unwrap: software.amazon.awssdk.services.codecatalyst.model.FilterKey
}
object FilterKey {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.FilterKey
  ): zio.aws.codecatalyst.model.FilterKey = value match {
    case software.amazon.awssdk.services.codecatalyst.model.FilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.FilterKey.HAS_ACCESS_TO =>
      val r = hasAccessTo
      r
  }
  case object unknownToSdkVersion extends zio.aws.codecatalyst.model.FilterKey {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.FilterKey =
      software.amazon.awssdk.services.codecatalyst.model.FilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object hasAccessTo extends zio.aws.codecatalyst.model.FilterKey {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.FilterKey =
      software.amazon.awssdk.services.codecatalyst.model.FilterKey.HAS_ACCESS_TO
  }
}
