package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DevEnvironmentAccessDetails(
    streamUrl: SensitiveString,
    tokenValue: SensitiveString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentAccessDetails = {
    import DevEnvironmentAccessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentAccessDetails
      .builder()
      .streamUrl(SensitiveString.unwrap(streamUrl): java.lang.String)
      .tokenValue(SensitiveString.unwrap(tokenValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.ReadOnly =
    zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.wrap(buildAwsValue())
}
object DevEnvironmentAccessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentAccessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DevEnvironmentAccessDetails =
      zio.aws.codecatalyst.model
        .DevEnvironmentAccessDetails(streamUrl, tokenValue)
    def streamUrl: SensitiveString
    def tokenValue: SensitiveString
    def getStreamUrl: ZIO[Any, Nothing, SensitiveString] =
      ZIO.succeed(streamUrl)
    def getTokenValue: ZIO[Any, Nothing, SensitiveString] =
      ZIO.succeed(tokenValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentAccessDetails
  ) extends zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.ReadOnly {
    override val streamUrl: SensitiveString =
      zio.aws.codecatalyst.model.primitives.SensitiveString(impl.streamUrl())
    override val tokenValue: SensitiveString =
      zio.aws.codecatalyst.model.primitives.SensitiveString(impl.tokenValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentAccessDetails
  ): zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.ReadOnly =
    new Wrapper(impl)
}
