package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  Timestamp,
  SourceRepositoryDescriptionString,
  SourceRepositoryNameString,
  SourceRepositoryIdString
}
import scala.jdk.CollectionConverters._
final case class ListSourceRepositoriesItem(
    id: SourceRepositoryIdString,
    name: SourceRepositoryNameString,
    description: Optional[SourceRepositoryDescriptionString] = Optional.Absent,
    lastUpdatedTime: Timestamp,
    createdTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem = {
    import ListSourceRepositoriesItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem
      .builder()
      .id(SourceRepositoryIdString.unwrap(id): java.lang.String)
      .name(SourceRepositoryNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SourceRepositoryDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly =
    zio.aws.codecatalyst.model.ListSourceRepositoriesItem.wrap(buildAwsValue())
}
object ListSourceRepositoriesItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListSourceRepositoriesItem =
      zio.aws.codecatalyst.model.ListSourceRepositoriesItem(
        id,
        name,
        description.map(value => value),
        lastUpdatedTime,
        createdTime
      )
    def id: SourceRepositoryIdString
    def name: SourceRepositoryNameString
    def description: Optional[SourceRepositoryDescriptionString]
    def lastUpdatedTime: Timestamp
    def createdTime: Timestamp
    def getId: ZIO[Any, Nothing, SourceRepositoryIdString] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, SourceRepositoryDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem
  ) extends zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly {
    override val id: SourceRepositoryIdString =
      zio.aws.codecatalyst.model.primitives.SourceRepositoryIdString(impl.id())
    override val name: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.name())
    override val description: Optional[SourceRepositoryDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryDescriptionString(value)
        )
    override val lastUpdatedTime: Timestamp =
      zio.aws.codecatalyst.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val createdTime: Timestamp =
      zio.aws.codecatalyst.model.primitives.Timestamp(impl.createdTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem
  ): zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly =
    new Wrapper(impl)
}
