package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  InactivityTimeoutMinutes,
  UpdateDevEnvironmentResponseAliasString,
  Uuid,
  ClientToken,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateDevEnvironmentResponse(
    id: Uuid,
    spaceName: NameString,
    projectName: NameString,
    alias: Optional[UpdateDevEnvironmentResponseAliasString] = Optional.Absent,
    ides: Optional[Iterable[zio.aws.codecatalyst.model.IdeConfiguration]] =
      Optional.Absent,
    instanceType: Optional[zio.aws.codecatalyst.model.InstanceType] =
      Optional.Absent,
    inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse = {
    import UpdateDevEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse
      .builder()
      .id(Uuid.unwrap(id): java.lang.String)
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .optionallyWith(
        alias.map(value =>
          UpdateDevEnvironmentResponseAliasString.unwrap(
            value
          ): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        ides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ides)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        inactivityTimeoutMinutes.map(value =>
          InactivityTimeoutMinutes.unwrap(value): Integer
        )
      )(_.inactivityTimeoutMinutes)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly =
    zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse
      .wrap(buildAwsValue())
}
object UpdateDevEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse =
      zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse(
        id,
        spaceName,
        projectName,
        alias.map(value => value),
        ides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceType.map(value => value),
        inactivityTimeoutMinutes.map(value => value),
        clientToken.map(value => value)
      )
    def id: Uuid
    def spaceName: NameString
    def projectName: NameString
    def alias: Optional[UpdateDevEnvironmentResponseAliasString]
    def ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]]
    def instanceType: Optional[zio.aws.codecatalyst.model.InstanceType]
    def inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes]
    def clientToken: Optional[ClientToken]
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getAlias: ZIO[Any, AwsError, UpdateDevEnvironmentResponseAliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getIdes: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("ides", ides)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.codecatalyst.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInactivityTimeoutMinutes
        : ZIO[Any, AwsError, InactivityTimeoutMinutes] = AwsError
      .unwrapOptionField("inactivityTimeoutMinutes", inactivityTimeoutMinutes)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse
  ) extends zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly {
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val alias: Optional[UpdateDevEnvironmentResponseAliasString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .UpdateDevEnvironmentResponseAliasString(value)
        )
    override val ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.IdeConfiguration.wrap(item)
          }.toList
        )
    override val instanceType
        : Optional[zio.aws.codecatalyst.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.codecatalyst.model.InstanceType.wrap(value))
    override val inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inactivityTimeoutMinutes())
        .map(value =>
          zio.aws.codecatalyst.model.primitives.InactivityTimeoutMinutes(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.codecatalyst.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse
  ): zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
