package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  SyntheticTimestamp_date_time,
  SourceRepositoryBranchString,
  SourceRepositoryBranchRefString
}
import scala.jdk.CollectionConverters._
final case class ListSourceRepositoryBranchesItem(
    ref: Optional[SourceRepositoryBranchRefString] = Optional.Absent,
    name: Optional[SourceRepositoryBranchString] = Optional.Absent,
    lastUpdatedTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    headCommitId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem = {
    import ListSourceRepositoryBranchesItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem
      .builder()
      .optionallyWith(
        ref.map(value =>
          SourceRepositoryBranchRefString.unwrap(value): java.lang.String
        )
      )(_.ref)
      .optionallyWith(
        name.map(value =>
          SourceRepositoryBranchString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        lastUpdatedTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedTime)
      .optionallyWith(headCommitId.map(value => value: java.lang.String))(
        _.headCommitId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly =
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem
      .wrap(buildAwsValue())
}
object ListSourceRepositoryBranchesItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem =
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem(
        ref.map(value => value),
        name.map(value => value),
        lastUpdatedTime.map(value => value),
        headCommitId.map(value => value)
      )
    def ref: Optional[SourceRepositoryBranchRefString]
    def name: Optional[SourceRepositoryBranchString]
    def lastUpdatedTime: Optional[SyntheticTimestamp_date_time]
    def headCommitId: Optional[String]
    def getRef: ZIO[Any, AwsError, SourceRepositoryBranchRefString] =
      AwsError.unwrapOptionField("ref", ref)
    def getName: ZIO[Any, AwsError, SourceRepositoryBranchString] =
      AwsError.unwrapOptionField("name", name)
    def getLastUpdatedTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getHeadCommitId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("headCommitId", headCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem
  ) extends zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly {
    override val ref: Optional[SourceRepositoryBranchRefString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ref())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryBranchRefString(value)
        )
    override val name: Optional[SourceRepositoryBranchString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryBranchString(value)
        )
    override val lastUpdatedTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val headCommitId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.headCommitId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem
  ): zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly =
    new Wrapper(impl)
}
