package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  Timestamp,
  SourceRepositoryDescriptionString,
  SourceRepositoryNameString,
  NameString
}
import scala.jdk.CollectionConverters._
final case class GetSourceRepositoryResponse(
    spaceName: NameString,
    projectName: NameString,
    name: SourceRepositoryNameString,
    description: Optional[SourceRepositoryDescriptionString] = Optional.Absent,
    lastUpdatedTime: Timestamp,
    createdTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryResponse = {
    import GetSourceRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .name(SourceRepositoryNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SourceRepositoryDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly =
    zio.aws.codecatalyst.model.GetSourceRepositoryResponse.wrap(buildAwsValue())
}
object GetSourceRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetSourceRepositoryResponse =
      zio.aws.codecatalyst.model.GetSourceRepositoryResponse(
        spaceName,
        projectName,
        name,
        description.map(value => value),
        lastUpdatedTime,
        createdTime
      )
    def spaceName: NameString
    def projectName: NameString
    def name: SourceRepositoryNameString
    def description: Optional[SourceRepositoryDescriptionString]
    def lastUpdatedTime: Timestamp
    def createdTime: Timestamp
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, SourceRepositoryDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryResponse
  ) extends zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val name: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.name())
    override val description: Optional[SourceRepositoryDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryDescriptionString(value)
        )
    override val lastUpdatedTime: Timestamp =
      zio.aws.codecatalyst.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val createdTime: Timestamp =
      zio.aws.codecatalyst.model.primitives.Timestamp(impl.createdTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryResponse
  ): zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
