package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{Uuid, NameString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateDevEnvironmentResponse(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse = {
    import CreateDevEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly =
    zio.aws.codecatalyst.model.CreateDevEnvironmentResponse
      .wrap(buildAwsValue())
}
object CreateDevEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateDevEnvironmentResponse =
      zio.aws.codecatalyst.model
        .CreateDevEnvironmentResponse(spaceName, projectName, id)
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse
  ) extends zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse
  ): zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
