package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  InactivityTimeoutMinutes,
  UpdateDevEnvironmentRequestAliasString,
  Uuid,
  ClientToken,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateDevEnvironmentRequest(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    alias: Optional[UpdateDevEnvironmentRequestAliasString] = Optional.Absent,
    ides: Optional[Iterable[zio.aws.codecatalyst.model.IdeConfiguration]] =
      Optional.Absent,
    instanceType: Optional[zio.aws.codecatalyst.model.InstanceType] =
      Optional.Absent,
    inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest = {
    import UpdateDevEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .optionallyWith(
        alias.map(value =>
          UpdateDevEnvironmentRequestAliasString.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        ides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ides)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        inactivityTimeoutMinutes.map(value =>
          InactivityTimeoutMinutes.unwrap(value): Integer
        )
      )(_.inactivityTimeoutMinutes)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.UpdateDevEnvironmentRequest.ReadOnly =
    zio.aws.codecatalyst.model.UpdateDevEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateDevEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UpdateDevEnvironmentRequest =
      zio.aws.codecatalyst.model.UpdateDevEnvironmentRequest(
        spaceName,
        projectName,
        id,
        alias.map(value => value),
        ides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceType.map(value => value),
        inactivityTimeoutMinutes.map(value => value),
        clientToken.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def alias: Optional[UpdateDevEnvironmentRequestAliasString]
    def ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]]
    def instanceType: Optional[zio.aws.codecatalyst.model.InstanceType]
    def inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes]
    def clientToken: Optional[ClientToken]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getAlias: ZIO[Any, AwsError, UpdateDevEnvironmentRequestAliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getIdes: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("ides", ides)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.codecatalyst.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInactivityTimeoutMinutes
        : ZIO[Any, AwsError, InactivityTimeoutMinutes] = AwsError
      .unwrapOptionField("inactivityTimeoutMinutes", inactivityTimeoutMinutes)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest
  ) extends zio.aws.codecatalyst.model.UpdateDevEnvironmentRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val alias: Optional[UpdateDevEnvironmentRequestAliasString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .UpdateDevEnvironmentRequestAliasString(value)
        )
    override val ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.IdeConfiguration.wrap(item)
          }.toList
        )
    override val instanceType
        : Optional[zio.aws.codecatalyst.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.codecatalyst.model.InstanceType.wrap(value))
    override val inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inactivityTimeoutMinutes())
        .map(value =>
          zio.aws.codecatalyst.model.primitives.InactivityTimeoutMinutes(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.codecatalyst.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest
  ): zio.aws.codecatalyst.model.UpdateDevEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
