package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EmailAddress(
    email: Optional[String] = Optional.Absent,
    verified: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.EmailAddress = {
    import EmailAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.EmailAddress
      .builder()
      .optionallyWith(email.map(value => value: java.lang.String))(_.email)
      .optionallyWith(verified.map(value => value: java.lang.Boolean))(
        _.verified
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.EmailAddress.ReadOnly =
    zio.aws.codecatalyst.model.EmailAddress.wrap(buildAwsValue())
}
object EmailAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.EmailAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.EmailAddress =
      zio.aws.codecatalyst.model
        .EmailAddress(email.map(value => value), verified.map(value => value))
    def email: Optional[String]
    def verified: Optional[Boolean]
    def getEmail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("email", email)
    def getVerified: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("verified", verified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.EmailAddress
  ) extends zio.aws.codecatalyst.model.EmailAddress.ReadOnly {
    override val email: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => value: String)
    override val verified: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.verified())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.EmailAddress
  ): zio.aws.codecatalyst.model.EmailAddress.ReadOnly = new Wrapper(impl)
}
