package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProjectRequest(spaceName: NameString, name: NameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest = {
    import GetProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetProjectRequest.ReadOnly =
    zio.aws.codecatalyst.model.GetProjectRequest.wrap(buildAwsValue())
}
object GetProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetProjectRequest =
      zio.aws.codecatalyst.model.GetProjectRequest(spaceName, name)
    def spaceName: NameString
    def name: NameString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest
  ) extends zio.aws.codecatalyst.model.GetProjectRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest
  ): zio.aws.codecatalyst.model.GetProjectRequest.ReadOnly = new Wrapper(impl)
}
