package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  InactivityTimeoutMinutes,
  StatusReason,
  SyntheticTimestamp_date_time,
  GetDevEnvironmentResponseAliasString,
  Uuid,
  NameString,
  GetDevEnvironmentResponseCreatorIdString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDevEnvironmentResponse(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    lastUpdatedTime: SyntheticTimestamp_date_time,
    creatorId: GetDevEnvironmentResponseCreatorIdString,
    status: zio.aws.codecatalyst.model.DevEnvironmentStatus,
    statusReason: Optional[StatusReason] = Optional.Absent,
    repositories: Iterable[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary
    ],
    alias: Optional[GetDevEnvironmentResponseAliasString] = Optional.Absent,
    ides: Optional[Iterable[zio.aws.codecatalyst.model.Ide]] = Optional.Absent,
    instanceType: zio.aws.codecatalyst.model.InstanceType,
    inactivityTimeoutMinutes: InactivityTimeoutMinutes,
    persistentStorage: zio.aws.codecatalyst.model.PersistentStorage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse = {
    import GetDevEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .lastUpdatedTime(
        SyntheticTimestamp_date_time.unwrap(lastUpdatedTime): Instant
      )
      .creatorId(
        GetDevEnvironmentResponseCreatorIdString.unwrap(
          creatorId
        ): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .repositories(repositories.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        alias.map(value =>
          GetDevEnvironmentResponseAliasString.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        ides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ides)
      .instanceType(instanceType.unwrap)
      .inactivityTimeoutMinutes(
        InactivityTimeoutMinutes.unwrap(inactivityTimeoutMinutes): Integer
      )
      .persistentStorage(persistentStorage.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly =
    zio.aws.codecatalyst.model.GetDevEnvironmentResponse.wrap(buildAwsValue())
}
object GetDevEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetDevEnvironmentResponse =
      zio.aws.codecatalyst.model.GetDevEnvironmentResponse(
        spaceName,
        projectName,
        id,
        lastUpdatedTime,
        creatorId,
        status,
        statusReason.map(value => value),
        repositories.map { item =>
          item.asEditable
        },
        alias.map(value => value),
        ides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceType,
        inactivityTimeoutMinutes,
        persistentStorage.asEditable
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def lastUpdatedTime: SyntheticTimestamp_date_time
    def creatorId: GetDevEnvironmentResponseCreatorIdString
    def status: zio.aws.codecatalyst.model.DevEnvironmentStatus
    def statusReason: Optional[StatusReason]
    def repositories: List[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly
    ]
    def alias: Optional[GetDevEnvironmentResponseAliasString]
    def ides: Optional[List[zio.aws.codecatalyst.model.Ide.ReadOnly]]
    def instanceType: zio.aws.codecatalyst.model.InstanceType
    def inactivityTimeoutMinutes: InactivityTimeoutMinutes
    def persistentStorage: zio.aws.codecatalyst.model.PersistentStorage.ReadOnly
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getLastUpdatedTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(lastUpdatedTime)
    def getCreatorId
        : ZIO[Any, Nothing, GetDevEnvironmentResponseCreatorIdString] =
      ZIO.succeed(creatorId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codecatalyst.model.DevEnvironmentStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getRepositories: ZIO[Any, Nothing, List[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly
    ]] = ZIO.succeed(repositories)
    def getAlias: ZIO[Any, AwsError, GetDevEnvironmentResponseAliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getIdes
        : ZIO[Any, AwsError, List[zio.aws.codecatalyst.model.Ide.ReadOnly]] =
      AwsError.unwrapOptionField("ides", ides)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.codecatalyst.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getInactivityTimeoutMinutes
        : ZIO[Any, Nothing, InactivityTimeoutMinutes] =
      ZIO.succeed(inactivityTimeoutMinutes)
    def getPersistentStorage: ZIO[
      Any,
      Nothing,
      zio.aws.codecatalyst.model.PersistentStorage.ReadOnly
    ] = ZIO.succeed(persistentStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse
  ) extends zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val lastUpdatedTime: SyntheticTimestamp_date_time =
      zio.aws.codecatalyst.model.primitives
        .SyntheticTimestamp_date_time(impl.lastUpdatedTime())
    override val creatorId: GetDevEnvironmentResponseCreatorIdString =
      zio.aws.codecatalyst.model.primitives
        .GetDevEnvironmentResponseCreatorIdString(impl.creatorId())
    override val status: zio.aws.codecatalyst.model.DevEnvironmentStatus =
      zio.aws.codecatalyst.model.DevEnvironmentStatus.wrap(impl.status())
    override val statusReason: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.codecatalyst.model.primitives.StatusReason(value))
    override val repositories: List[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly
    ] = impl
      .repositories()
      .asScala
      .map { item =>
        zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.wrap(item)
      }
      .toList
    override val alias: Optional[GetDevEnvironmentResponseAliasString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .GetDevEnvironmentResponseAliasString(value)
        )
    override val ides: Optional[List[zio.aws.codecatalyst.model.Ide.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.Ide.wrap(item)
          }.toList
        )
    override val instanceType: zio.aws.codecatalyst.model.InstanceType =
      zio.aws.codecatalyst.model.InstanceType.wrap(impl.instanceType())
    override val inactivityTimeoutMinutes: InactivityTimeoutMinutes =
      zio.aws.codecatalyst.model.primitives
        .InactivityTimeoutMinutes(impl.inactivityTimeoutMinutes())
    override val persistentStorage
        : zio.aws.codecatalyst.model.PersistentStorage.ReadOnly =
      zio.aws.codecatalyst.model.PersistentStorage
        .wrap(impl.persistentStorage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse
  ): zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
