package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListProjectsRequestMaxResultsInteger,
  ListProjectsRequestNextTokenString,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProjectsRequest(
    spaceName: NameString,
    nextToken: Optional[ListProjectsRequestNextTokenString] = Optional.Absent,
    maxResults: Optional[ListProjectsRequestMaxResultsInteger] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.codecatalyst.model.ProjectListFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          ListProjectsRequestNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListProjectsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListProjectsRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListProjectsRequest =
      zio.aws.codecatalyst.model.ListProjectsRequest(
        spaceName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def spaceName: NameString
    def nextToken: Optional[ListProjectsRequestNextTokenString]
    def maxResults: Optional[ListProjectsRequestMaxResultsInteger]
    def filters
        : Optional[List[zio.aws.codecatalyst.model.ProjectListFilter.ReadOnly]]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getNextToken: ZIO[Any, AwsError, ListProjectsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListProjectsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.ProjectListFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest
  ) extends zio.aws.codecatalyst.model.ListProjectsRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val nextToken: Optional[ListProjectsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListProjectsRequestNextTokenString(value)
        )
    override val maxResults: Optional[ListProjectsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListProjectsRequestMaxResultsInteger(value)
        )
    override val filters: Optional[
      List[zio.aws.codecatalyst.model.ProjectListFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecatalyst.model.ProjectListFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest
  ): zio.aws.codecatalyst.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
