package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSourceRepositoriesResponse(
    items: Optional[
      Iterable[zio.aws.codecatalyst.model.ListSourceRepositoriesItem]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse = {
    import ListSourceRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListSourceRepositoriesResponse
      .wrap(buildAwsValue())
}
object ListSourceRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListSourceRepositoriesResponse =
      zio.aws.codecatalyst.model.ListSourceRepositoriesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[
      List[zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse
  ) extends zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecatalyst.model.ListSourceRepositoriesItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse
  ): zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly =
    new Wrapper(impl)
}
