package zio.aws.codecatalyst.model
import java.lang.Integer
import zio.aws.codecatalyst.model.primitives.PersistentStorageSizeInGiBInteger
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PersistentStorage(
    sizeInGiB: PersistentStorageSizeInGiBInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.PersistentStorage = {
    import PersistentStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.PersistentStorage
      .builder()
      .sizeInGiB(PersistentStorageSizeInGiBInteger.unwrap(sizeInGiB): Integer)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.PersistentStorage.ReadOnly =
    zio.aws.codecatalyst.model.PersistentStorage.wrap(buildAwsValue())
}
object PersistentStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.PersistentStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.PersistentStorage =
      zio.aws.codecatalyst.model.PersistentStorage(sizeInGiB)
    def sizeInGiB: PersistentStorageSizeInGiBInteger
    def getSizeInGiB: ZIO[Any, Nothing, PersistentStorageSizeInGiBInteger] =
      ZIO.succeed(sizeInGiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.PersistentStorage
  ) extends zio.aws.codecatalyst.model.PersistentStorage.ReadOnly {
    override val sizeInGiB: PersistentStorageSizeInGiBInteger =
      zio.aws.codecatalyst.model.primitives
        .PersistentStorageSizeInGiBInteger(impl.sizeInGiB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.PersistentStorage
  ): zio.aws.codecatalyst.model.PersistentStorage.ReadOnly = new Wrapper(impl)
}
