package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{IdeNameString, IdeRuntimeString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ide(
    runtime: Optional[IdeRuntimeString] = Optional.Absent,
    name: Optional[IdeNameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.Ide = {
    import Ide.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.Ide
      .builder()
      .optionallyWith(
        runtime.map(value => IdeRuntimeString.unwrap(value): java.lang.String)
      )(_.runtime)
      .optionallyWith(
        name.map(value => IdeNameString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.Ide.ReadOnly =
    zio.aws.codecatalyst.model.Ide.wrap(buildAwsValue())
}
object Ide {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codecatalyst.model.Ide] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.Ide = zio.aws.codecatalyst.model
      .Ide(runtime.map(value => value), name.map(value => value))
    def runtime: Optional[IdeRuntimeString]
    def name: Optional[IdeNameString]
    def getRuntime: ZIO[Any, AwsError, IdeRuntimeString] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getName: ZIO[Any, AwsError, IdeNameString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.Ide
  ) extends zio.aws.codecatalyst.model.Ide.ReadOnly {
    override val runtime: Optional[IdeRuntimeString] = zio.aws.core.internal
      .optionalFromNullable(impl.runtime())
      .map(value =>
        zio.aws.codecatalyst.model.primitives.IdeRuntimeString(value)
      )
    override val name: Optional[IdeNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codecatalyst.model.primitives.IdeNameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.Ide
  ): zio.aws.codecatalyst.model.Ide.ReadOnly = new Wrapper(impl)
}
