package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{Uuid, NameString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopDevEnvironmentResponse(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    status: zio.aws.codecatalyst.model.DevEnvironmentStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse = {
    import StopDevEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly =
    zio.aws.codecatalyst.model.StopDevEnvironmentResponse.wrap(buildAwsValue())
}
object StopDevEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.StopDevEnvironmentResponse =
      zio.aws.codecatalyst.model.StopDevEnvironmentResponse(
        spaceName,
        projectName,
        id,
        status
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def status: zio.aws.codecatalyst.model.DevEnvironmentStatus
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codecatalyst.model.DevEnvironmentStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse
  ) extends zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val status: zio.aws.codecatalyst.model.DevEnvironmentStatus =
      zio.aws.codecatalyst.model.DevEnvironmentStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse
  ): zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
