package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    nextToken: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.codecatalyst.model.ProjectSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListProjectsResponse =
      zio.aws.codecatalyst.model.ListProjectsResponse(
        nextToken.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def items
        : Optional[List[zio.aws.codecatalyst.model.ProjectSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.ProjectSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse
  ) extends zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.codecatalyst.model.ProjectSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.ProjectSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse
  ): zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
