package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSubscriptionResponse(
    subscriptionType: Optional[String] = Optional.Absent,
    awsAccountName: Optional[NameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse = {
    import GetSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse
      .builder()
      .optionallyWith(subscriptionType.map(value => value: java.lang.String))(
        _.subscriptionType
      )
      .optionallyWith(
        awsAccountName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.awsAccountName)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly =
    zio.aws.codecatalyst.model.GetSubscriptionResponse.wrap(buildAwsValue())
}
object GetSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetSubscriptionResponse =
      zio.aws.codecatalyst.model.GetSubscriptionResponse(
        subscriptionType.map(value => value),
        awsAccountName.map(value => value)
      )
    def subscriptionType: Optional[String]
    def awsAccountName: Optional[NameString]
    def getSubscriptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subscriptionType", subscriptionType)
    def getAwsAccountName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("awsAccountName", awsAccountName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse
  ) extends zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly {
    override val subscriptionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionType())
      .map(value => value: String)
    override val awsAccountName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountName())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse
  ): zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
