package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Filter(
    key: String,
    values: Iterable[String],
    comparisonOperator: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.Filter
      .builder()
      .key(key: java.lang.String)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(comparisonOperator.map(value => value: java.lang.String))(
        _.comparisonOperator
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.Filter.ReadOnly =
    zio.aws.codecatalyst.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.Filter =
      zio.aws.codecatalyst.model
        .Filter(key, values, comparisonOperator.map(value => value))
    def key: String
    def values: List[String]
    def comparisonOperator: Optional[String]
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[String]] = ZIO.succeed(values)
    def getComparisonOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.Filter
  ) extends zio.aws.codecatalyst.model.Filter.ReadOnly {
    override val key: String = impl.key(): String
    override val values: List[String] = impl
      .values()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val comparisonOperator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comparisonOperator())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.Filter
  ): zio.aws.codecatalyst.model.Filter.ReadOnly = new Wrapper(impl)
}
