package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  SyntheticTimestamp_date_time,
  AccessTokenName
}
import scala.jdk.CollectionConverters._
final case class CreateAccessTokenRequest(
    name: AccessTokenName,
    expiresTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest = {
    import CreateAccessTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest
      .builder()
      .name(AccessTokenName.unwrap(name): java.lang.String)
      .optionallyWith(
        expiresTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.expiresTime)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.CreateAccessTokenRequest.ReadOnly =
    zio.aws.codecatalyst.model.CreateAccessTokenRequest.wrap(buildAwsValue())
}
object CreateAccessTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateAccessTokenRequest =
      zio.aws.codecatalyst.model
        .CreateAccessTokenRequest(name, expiresTime.map(value => value))
    def name: AccessTokenName
    def expiresTime: Optional[SyntheticTimestamp_date_time]
    def getName: ZIO[Any, Nothing, AccessTokenName] = ZIO.succeed(name)
    def getExpiresTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("expiresTime", expiresTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest
  ) extends zio.aws.codecatalyst.model.CreateAccessTokenRequest.ReadOnly {
    override val name: AccessTokenName =
      zio.aws.codecatalyst.model.primitives.AccessTokenName(impl.name())
    override val expiresTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiresTime())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest
  ): zio.aws.codecatalyst.model.CreateAccessTokenRequest.ReadOnly = new Wrapper(
    impl
  )
}
