package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  InactivityTimeoutMinutes,
  Uuid,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartDevEnvironmentRequest(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    ides: Optional[Iterable[zio.aws.codecatalyst.model.IdeConfiguration]] =
      Optional.Absent,
    instanceType: Optional[zio.aws.codecatalyst.model.InstanceType] =
      Optional.Absent,
    inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest = {
    import StartDevEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .optionallyWith(
        ides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ides)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        inactivityTimeoutMinutes.map(value =>
          InactivityTimeoutMinutes.unwrap(value): Integer
        )
      )(_.inactivityTimeoutMinutes)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StartDevEnvironmentRequest.ReadOnly =
    zio.aws.codecatalyst.model.StartDevEnvironmentRequest.wrap(buildAwsValue())
}
object StartDevEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.StartDevEnvironmentRequest =
      zio.aws.codecatalyst.model.StartDevEnvironmentRequest(
        spaceName,
        projectName,
        id,
        ides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceType.map(value => value),
        inactivityTimeoutMinutes.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]]
    def instanceType: Optional[zio.aws.codecatalyst.model.InstanceType]
    def inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getIdes: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("ides", ides)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.codecatalyst.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInactivityTimeoutMinutes
        : ZIO[Any, AwsError, InactivityTimeoutMinutes] = AwsError
      .unwrapOptionField("inactivityTimeoutMinutes", inactivityTimeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest
  ) extends zio.aws.codecatalyst.model.StartDevEnvironmentRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.IdeConfiguration.wrap(item)
          }.toList
        )
    override val instanceType
        : Optional[zio.aws.codecatalyst.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.codecatalyst.model.InstanceType.wrap(value))
    override val inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inactivityTimeoutMinutes())
        .map(value =>
          zio.aws.codecatalyst.model.primitives.InactivityTimeoutMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest
  ): zio.aws.codecatalyst.model.StartDevEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
