package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  SourceRepositoryBranchString,
  SourceRepositoryNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DevEnvironmentRepositorySummary(
    repositoryName: SourceRepositoryNameString,
    branchName: Optional[SourceRepositoryBranchString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummary = {
    import DevEnvironmentRepositorySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummary
      .builder()
      .repositoryName(
        SourceRepositoryNameString.unwrap(repositoryName): java.lang.String
      )
      .optionallyWith(
        branchName.map(value =>
          SourceRepositoryBranchString.unwrap(value): java.lang.String
        )
      )(_.branchName)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly =
    zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary
      .wrap(buildAwsValue())
}
object DevEnvironmentRepositorySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary =
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary(
        repositoryName,
        branchName.map(value => value)
      )
    def repositoryName: SourceRepositoryNameString
    def branchName: Optional[SourceRepositoryBranchString]
    def getRepositoryName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, AwsError, SourceRepositoryBranchString] =
      AwsError.unwrapOptionField("branchName", branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummary
  ) extends zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly {
    override val repositoryName: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.repositoryName())
    override val branchName: Optional[SourceRepositoryBranchString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchName())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryBranchString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentRepositorySummary
  ): zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly =
    new Wrapper(impl)
}
