package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  GetUserDetailsRequestUserNameString,
  GetUserDetailsRequestIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUserDetailsRequest(
    id: Optional[GetUserDetailsRequestIdString] = Optional.Absent,
    userName: Optional[GetUserDetailsRequestUserNameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest = {
    import GetUserDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest
      .builder()
      .optionallyWith(
        id.map(value =>
          GetUserDetailsRequestIdString.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        userName.map(value =>
          GetUserDetailsRequestUserNameString.unwrap(value): java.lang.String
        )
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetUserDetailsRequest.ReadOnly =
    zio.aws.codecatalyst.model.GetUserDetailsRequest.wrap(buildAwsValue())
}
object GetUserDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetUserDetailsRequest =
      zio.aws.codecatalyst.model.GetUserDetailsRequest(
        id.map(value => value),
        userName.map(value => value)
      )
    def id: Optional[GetUserDetailsRequestIdString]
    def userName: Optional[GetUserDetailsRequestUserNameString]
    def getId: ZIO[Any, AwsError, GetUserDetailsRequestIdString] =
      AwsError.unwrapOptionField("id", id)
    def getUserName: ZIO[Any, AwsError, GetUserDetailsRequestUserNameString] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest
  ) extends zio.aws.codecatalyst.model.GetUserDetailsRequest.ReadOnly {
    override val id: Optional[GetUserDetailsRequestIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .GetUserDetailsRequestIdString(value)
        )
    override val userName: Optional[GetUserDetailsRequestUserNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userName())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .GetUserDetailsRequestUserNameString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest
  ): zio.aws.codecatalyst.model.GetUserDetailsRequest.ReadOnly = new Wrapper(
    impl
  )
}
