package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  SourceRepositoryNameString,
  NameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSourceRepositoryCloneUrlsRequest(
    spaceName: NameString,
    projectName: NameString,
    sourceRepositoryName: SourceRepositoryNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest = {
    import GetSourceRepositoryCloneUrlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .sourceRepositoryName(
        SourceRepositoryNameString.unwrap(
          sourceRepositoryName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest.ReadOnly =
    zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
      .wrap(buildAwsValue())
}
object GetSourceRepositoryCloneUrlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest =
      zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest(
        spaceName,
        projectName,
        sourceRepositoryName
      )
    def spaceName: NameString
    def projectName: NameString
    def sourceRepositoryName: SourceRepositoryNameString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getSourceRepositoryName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(sourceRepositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
  ) extends zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val sourceRepositoryName: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.sourceRepositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
  ): zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest.ReadOnly =
    new Wrapper(impl)
}
