package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ReportWithRawData(
    reportArn: Optional[NonEmptyString] = Optional.Absent,
    data: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportWithRawData = {
    import ReportWithRawData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportWithRawData
      .builder()
      .optionallyWith(
        reportArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reportArn)
      .optionallyWith(data.map(value => value: java.lang.String))(_.data)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportWithRawData.ReadOnly =
    zio.aws.codebuild.model.ReportWithRawData.wrap(buildAwsValue())
}
object ReportWithRawData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportWithRawData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportWithRawData =
      zio.aws.codebuild.model.ReportWithRawData(
        reportArn.map(value => value),
        data.map(value => value)
      )
    def reportArn: Optional[NonEmptyString]
    def data: Optional[String]
    def getReportArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportArn", reportArn)
    def getData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportWithRawData
  ) extends zio.aws.codebuild.model.ReportWithRawData.ReadOnly {
    override val reportArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reportArn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val data: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportWithRawData
  ): zio.aws.codebuild.model.ReportWithRawData.ReadOnly = new Wrapper(impl)
}
