package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait BuildBatchPhaseType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType
}
object BuildBatchPhaseType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType
  ): zio.aws.codebuild.model.BuildBatchPhaseType = value match {
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.DOWNLOAD_BATCHSPEC =>
      val r = DOWNLOAD_BATCHSPEC
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.COMBINE_ARTIFACTS =>
      val r = COMBINE_ARTIFACTS
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.SUBMITTED
  }
  case object DOWNLOAD_BATCHSPEC
      extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.DOWNLOAD_BATCHSPEC
  }
  case object IN_PROGRESS extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.IN_PROGRESS
  }
  case object COMBINE_ARTIFACTS
      extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.COMBINE_ARTIFACTS
  }
  case object SUCCEEDED extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.SUCCEEDED
  }
  case object FAILED extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.FAILED
  }
  case object STOPPED extends zio.aws.codebuild.model.BuildBatchPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildBatchPhaseType.STOPPED
  }
}
