package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class UpdateProjectVisibilityResponse(
    projectArn: Optional[NonEmptyString] = Optional.Absent,
    publicProjectAlias: Optional[NonEmptyString] = Optional.Absent,
    projectVisibility: Optional[zio.aws.codebuild.model.ProjectVisibilityType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse = {
    import UpdateProjectVisibilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse
      .builder()
      .optionallyWith(
        projectArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        publicProjectAlias.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicProjectAlias)
      .optionallyWith(projectVisibility.map(value => value.unwrap))(
        _.projectVisibility
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly =
    zio.aws.codebuild.model.UpdateProjectVisibilityResponse
      .wrap(buildAwsValue())
}
object UpdateProjectVisibilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateProjectVisibilityResponse =
      zio.aws.codebuild.model.UpdateProjectVisibilityResponse(
        projectArn.map(value => value),
        publicProjectAlias.map(value => value),
        projectVisibility.map(value => value)
      )
    def projectArn: Optional[NonEmptyString]
    def publicProjectAlias: Optional[NonEmptyString]
    def projectVisibility
        : Optional[zio.aws.codebuild.model.ProjectVisibilityType]
    def getProjectArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getPublicProjectAlias: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicProjectAlias", publicProjectAlias)
    def getProjectVisibility
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectVisibilityType] =
      AwsError.unwrapOptionField("projectVisibility", projectVisibility)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse
  ) extends zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly {
    override val projectArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.projectArn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val publicProjectAlias: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicProjectAlias())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val projectVisibility
        : Optional[zio.aws.codebuild.model.ProjectVisibilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectVisibility())
        .map(value => zio.aws.codebuild.model.ProjectVisibilityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse
  ): zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly =
    new Wrapper(impl)
}
