package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait WebhookBuildType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.WebhookBuildType
}
object WebhookBuildType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.WebhookBuildType
  ): zio.aws.codebuild.model.WebhookBuildType = value match {
    case software.amazon.awssdk.services.codebuild.model.WebhookBuildType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookBuildType.BUILD =>
      val r = BUILD
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookBuildType.BUILD_BATCH =>
      val r = BUILD_BATCH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.WebhookBuildType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookBuildType =
      software.amazon.awssdk.services.codebuild.model.WebhookBuildType.UNKNOWN_TO_SDK_VERSION
  }
  case object BUILD extends zio.aws.codebuild.model.WebhookBuildType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookBuildType =
      software.amazon.awssdk.services.codebuild.model.WebhookBuildType.BUILD
  }
  case object BUILD_BATCH extends zio.aws.codebuild.model.WebhookBuildType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookBuildType =
      software.amazon.awssdk.services.codebuild.model.WebhookBuildType.BUILD_BATCH
  }
}
