package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReportFilter(
    status: Optional[zio.aws.codebuild.model.ReportStatusType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportFilter = {
    import ReportFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportFilter.ReadOnly =
    zio.aws.codebuild.model.ReportFilter.wrap(buildAwsValue())
}
object ReportFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportFilter =
      zio.aws.codebuild.model.ReportFilter(status.map(value => value))
    def status: Optional[zio.aws.codebuild.model.ReportStatusType]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportStatusType] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportFilter
  ) extends zio.aws.codebuild.model.ReportFilter.ReadOnly {
    override val status: Optional[zio.aws.codebuild.model.ReportStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codebuild.model.ReportStatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportFilter
  ): zio.aws.codebuild.model.ReportFilter.ReadOnly = new Wrapper(impl)
}
