package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class BatchGetBuildBatchesResponse(
    buildBatches: Optional[Iterable[zio.aws.codebuild.model.BuildBatch]] =
      Optional.Absent,
    buildBatchesNotFound: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse = {
    import BatchGetBuildBatchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse
      .builder()
      .optionallyWith(
        buildBatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buildBatches)
      .optionallyWith(
        buildBatchesNotFound.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.buildBatchesNotFound)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly =
    zio.aws.codebuild.model.BatchGetBuildBatchesResponse.wrap(buildAwsValue())
}
object BatchGetBuildBatchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetBuildBatchesResponse =
      zio.aws.codebuild.model.BatchGetBuildBatchesResponse(
        buildBatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildBatchesNotFound.map(value => value)
      )
    def buildBatches
        : Optional[List[zio.aws.codebuild.model.BuildBatch.ReadOnly]]
    def buildBatchesNotFound: Optional[List[NonEmptyString]]
    def getBuildBatches: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildBatch.ReadOnly
    ]] = AwsError.unwrapOptionField("buildBatches", buildBatches)
    def getBuildBatchesNotFound: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("buildBatchesNotFound", buildBatchesNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse
  ) extends zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly {
    override val buildBatches
        : Optional[List[zio.aws.codebuild.model.BuildBatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildBatch.wrap(item)
          }.toList
        )
    override val buildBatchesNotFound: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatchesNotFound())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse
  ): zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly =
    new Wrapper(impl)
}
