package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class RegistryCredential(
    credential: NonEmptyString,
    credentialProvider: zio.aws.codebuild.model.CredentialProviderType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.RegistryCredential = {
    import RegistryCredential.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.RegistryCredential
      .builder()
      .credential(NonEmptyString.unwrap(credential): java.lang.String)
      .credentialProvider(credentialProvider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.RegistryCredential.ReadOnly =
    zio.aws.codebuild.model.RegistryCredential.wrap(buildAwsValue())
}
object RegistryCredential {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.RegistryCredential
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.RegistryCredential =
      zio.aws.codebuild.model.RegistryCredential(credential, credentialProvider)
    def credential: NonEmptyString
    def credentialProvider: zio.aws.codebuild.model.CredentialProviderType
    def getCredential: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(credential)
    def getCredentialProvider
        : ZIO[Any, Nothing, zio.aws.codebuild.model.CredentialProviderType] =
      ZIO.succeed(credentialProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.RegistryCredential
  ) extends zio.aws.codebuild.model.RegistryCredential.ReadOnly {
    override val credential: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.credential())
    override val credentialProvider
        : zio.aws.codebuild.model.CredentialProviderType =
      zio.aws.codebuild.model.CredentialProviderType
        .wrap(impl.credentialProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.RegistryCredential
  ): zio.aws.codebuild.model.RegistryCredential.ReadOnly = new Wrapper(impl)
}
