package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{Timestamp, NonEmptyString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Webhook(
    url: Optional[NonEmptyString] = Optional.Absent,
    payloadUrl: Optional[NonEmptyString] = Optional.Absent,
    secret: Optional[NonEmptyString] = Optional.Absent,
    branchFilter: Optional[String] = Optional.Absent,
    filterGroups: Optional[
      Iterable[Iterable[zio.aws.codebuild.model.WebhookFilter]]
    ] = Optional.Absent,
    buildType: Optional[zio.aws.codebuild.model.WebhookBuildType] =
      Optional.Absent,
    lastModifiedSecret: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.Webhook = {
    import Webhook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Webhook
      .builder()
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        payloadUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.payloadUrl)
      .optionallyWith(
        secret.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.secret)
      .optionallyWith(branchFilter.map(value => value: java.lang.String))(
        _.branchFilter
      )
      .optionallyWith(
        filterGroups.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.filterGroups)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .optionallyWith(
        lastModifiedSecret.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedSecret)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Webhook.ReadOnly =
    zio.aws.codebuild.model.Webhook.wrap(buildAwsValue())
}
object Webhook {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Webhook] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Webhook =
      zio.aws.codebuild.model.Webhook(
        url.map(value => value),
        payloadUrl.map(value => value),
        secret.map(value => value),
        branchFilter.map(value => value),
        filterGroups.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        ),
        buildType.map(value => value),
        lastModifiedSecret.map(value => value)
      )
    def url: Optional[NonEmptyString]
    def payloadUrl: Optional[NonEmptyString]
    def secret: Optional[NonEmptyString]
    def branchFilter: Optional[String]
    def filterGroups
        : Optional[List[List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]]]
    def buildType: Optional[zio.aws.codebuild.model.WebhookBuildType]
    def lastModifiedSecret: Optional[Timestamp]
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getPayloadUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("payloadUrl", payloadUrl)
    def getSecret: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("secret", secret)
    def getBranchFilter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("branchFilter", branchFilter)
    def getFilterGroups: ZIO[Any, AwsError, List[
      List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]
    ]] = AwsError.unwrapOptionField("filterGroups", filterGroups)
    def getBuildType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.WebhookBuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
    def getLastModifiedSecret: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedSecret", lastModifiedSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Webhook
  ) extends zio.aws.codebuild.model.Webhook.ReadOnly {
    override val url: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val payloadUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.payloadUrl())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val secret: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.secret())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val branchFilter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.branchFilter())
      .map(value => value: String)
    override val filterGroups
        : Optional[List[List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterGroups())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.codebuild.model.WebhookFilter.wrap(item)
            }.toList
          }.toList
        )
    override val buildType: Optional[zio.aws.codebuild.model.WebhookBuildType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildType())
        .map(value => zio.aws.codebuild.model.WebhookBuildType.wrap(value))
    override val lastModifiedSecret: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedSecret())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Webhook
  ): zio.aws.codebuild.model.Webhook.ReadOnly = new Wrapper(impl)
}
