package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ComputeType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ComputeType
}
object ComputeType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ComputeType
  ): zio.aws.codebuild.model.ComputeType = value match {
    case software.amazon.awssdk.services.codebuild.model.ComputeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_SMALL =>
      val r = BUILD_GENERAL1_SMALL
      r
    case software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_MEDIUM =>
      val r = BUILD_GENERAL1_MEDIUM
      r
    case software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_LARGE =>
      val r = BUILD_GENERAL1_LARGE
      r
    case software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_2_XLARGE =>
      val r = BUILD_GENERAL1_2XLARGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ComputeType =
      software.amazon.awssdk.services.codebuild.model.ComputeType.UNKNOWN_TO_SDK_VERSION
  }
  case object BUILD_GENERAL1_SMALL extends zio.aws.codebuild.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ComputeType =
      software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_SMALL
  }
  case object BUILD_GENERAL1_MEDIUM
      extends zio.aws.codebuild.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ComputeType =
      software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_MEDIUM
  }
  case object BUILD_GENERAL1_LARGE extends zio.aws.codebuild.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ComputeType =
      software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_LARGE
  }
  case object BUILD_GENERAL1_2XLARGE
      extends zio.aws.codebuild.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ComputeType =
      software.amazon.awssdk.services.codebuild.model.ComputeType.BUILD_GENERAL1_2_XLARGE
  }
}
