package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BuildSummary(
    arn: Optional[String] = Optional.Absent,
    requestedOn: Optional[Timestamp] = Optional.Absent,
    buildStatus: Optional[zio.aws.codebuild.model.StatusType] = Optional.Absent,
    primaryArtifact: Optional[zio.aws.codebuild.model.ResolvedArtifact] =
      Optional.Absent,
    secondaryArtifacts: Optional[
      Iterable[zio.aws.codebuild.model.ResolvedArtifact]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildSummary = {
    import BuildSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        requestedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.requestedOn)
      .optionallyWith(buildStatus.map(value => value.unwrap))(_.buildStatus)
      .optionallyWith(primaryArtifact.map(value => value.buildAwsValue()))(
        _.primaryArtifact
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildSummary.ReadOnly =
    zio.aws.codebuild.model.BuildSummary.wrap(buildAwsValue())
}
object BuildSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildSummary =
      zio.aws.codebuild.model.BuildSummary(
        arn.map(value => value),
        requestedOn.map(value => value),
        buildStatus.map(value => value),
        primaryArtifact.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[String]
    def requestedOn: Optional[Timestamp]
    def buildStatus: Optional[zio.aws.codebuild.model.StatusType]
    def primaryArtifact
        : Optional[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly]
    def secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getRequestedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("requestedOn", requestedOn)
    def getBuildStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("buildStatus", buildStatus)
    def getPrimaryArtifact: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ResolvedArtifact.ReadOnly
    ] = AwsError.unwrapOptionField("primaryArtifact", primaryArtifact)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ResolvedArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildSummary
  ) extends zio.aws.codebuild.model.BuildSummary.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val requestedOn: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedOn())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val buildStatus: Optional[zio.aws.codebuild.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildStatus())
        .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val primaryArtifact
        : Optional[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryArtifact())
        .map(value => zio.aws.codebuild.model.ResolvedArtifact.wrap(value))
    override val secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ResolvedArtifact.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildSummary
  ): zio.aws.codebuild.model.BuildSummary.ReadOnly = new Wrapper(impl)
}
