package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.{NonEmptyString, WrapperBoolean}
import scala.jdk.CollectionConverters.*
final case class DebugSession(
    sessionEnabled: Optional[WrapperBoolean] = Optional.Absent,
    sessionTarget: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DebugSession = {
    import DebugSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DebugSession
      .builder()
      .optionallyWith(sessionEnabled.map(value => value: java.lang.Boolean))(
        _.sessionEnabled
      )
      .optionallyWith(
        sessionTarget.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sessionTarget)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DebugSession.ReadOnly =
    zio.aws.codebuild.model.DebugSession.wrap(buildAwsValue())
}
object DebugSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DebugSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DebugSession =
      zio.aws.codebuild.model.DebugSession(
        sessionEnabled.map(value => value),
        sessionTarget.map(value => value)
      )
    def sessionEnabled: Optional[WrapperBoolean]
    def sessionTarget: Optional[NonEmptyString]
    def getSessionEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("sessionEnabled", sessionEnabled)
    def getSessionTarget: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sessionTarget", sessionTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DebugSession
  ) extends zio.aws.codebuild.model.DebugSession.ReadOnly {
    override val sessionEnabled: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionEnabled())
        .map(value => value: WrapperBoolean)
    override val sessionTarget: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionTarget())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DebugSession
  ): zio.aws.codebuild.model.DebugSession.ReadOnly = new Wrapper(impl)
}
