package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.{ValueInput, KeyInput}
import scala.jdk.CollectionConverters.*
final case class Tag(
    key: Optional[KeyInput] = Optional.Absent,
    value: Optional[ValueInput] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.codebuild.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Tag
      .builder()
      .optionallyWith(
        key.map(value => KeyInput.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => ValueInput.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Tag.ReadOnly =
    zio.aws.codebuild.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Tag = zio.aws.codebuild.model
      .Tag(key.map(value => value), value.map(value => value))
    def key: Optional[KeyInput]
    def value: Optional[ValueInput]
    def getKey: ZIO[Any, AwsError, KeyInput] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ValueInput] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Tag
  ) extends zio.aws.codebuild.model.Tag.ReadOnly {
    override val key: Optional[KeyInput] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.codebuild.model.primitives.KeyInput(value))
    override val value: Optional[ValueInput] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.codebuild.model.primitives.ValueInput(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Tag
  ): zio.aws.codebuild.model.Tag.ReadOnly = new Wrapper(impl)
}
