package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class DeleteReportRequest(arn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteReportRequest = {
    import DeleteReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteReportRequest
      .builder()
      .arn(NonEmptyString.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DeleteReportRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteReportRequest.wrap(buildAwsValue())
}
object DeleteReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteReportRequest =
      zio.aws.codebuild.model.DeleteReportRequest(arn)
    def arn: NonEmptyString
    def getArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteReportRequest
  ) extends zio.aws.codebuild.model.DeleteReportRequest.ReadOnly {
    override val arn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteReportRequest
  ): zio.aws.codebuild.model.DeleteReportRequest.ReadOnly = new Wrapper(impl)
}
