package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartBuildBatchResponse(
    buildBatch: Optional[zio.aws.codebuild.model.BuildBatch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse = {
    import StartBuildBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse
      .builder()
      .optionallyWith(buildBatch.map(value => value.buildAwsValue()))(
        _.buildBatch
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly =
    zio.aws.codebuild.model.StartBuildBatchResponse.wrap(buildAwsValue())
}
object StartBuildBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StartBuildBatchResponse =
      zio.aws.codebuild.model
        .StartBuildBatchResponse(buildBatch.map(value => value.asEditable))
    def buildBatch: Optional[zio.aws.codebuild.model.BuildBatch.ReadOnly]
    def getBuildBatch
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildBatch.ReadOnly] =
      AwsError.unwrapOptionField("buildBatch", buildBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse
  ) extends zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly {
    override val buildBatch
        : Optional[zio.aws.codebuild.model.BuildBatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatch())
        .map(value => zio.aws.codebuild.model.BuildBatch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse
  ): zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly = new Wrapper(
    impl
  )
}
