package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class RetryBuildBatchRequest(
    id: Optional[NonEmptyString] = Optional.Absent,
    idempotencyToken: Optional[String] = Optional.Absent,
    retryType: Optional[zio.aws.codebuild.model.RetryBuildBatchType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest = {
    import RetryBuildBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(retryType.map(value => value.unwrap))(_.retryType)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.RetryBuildBatchRequest.ReadOnly =
    zio.aws.codebuild.model.RetryBuildBatchRequest.wrap(buildAwsValue())
}
object RetryBuildBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.RetryBuildBatchRequest =
      zio.aws.codebuild.model.RetryBuildBatchRequest(
        id.map(value => value),
        idempotencyToken.map(value => value),
        retryType.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def idempotencyToken: Optional[String]
    def retryType: Optional[zio.aws.codebuild.model.RetryBuildBatchType]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getRetryType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.RetryBuildBatchType] =
      AwsError.unwrapOptionField("retryType", retryType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest
  ) extends zio.aws.codebuild.model.RetryBuildBatchRequest.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val retryType
        : Optional[zio.aws.codebuild.model.RetryBuildBatchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryType())
        .map(value => zio.aws.codebuild.model.RetryBuildBatchType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest
  ): zio.aws.codebuild.model.RetryBuildBatchRequest.ReadOnly = new Wrapper(impl)
}
