package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  WrapperBoolean,
  Timestamp,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Report(
    arn: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[zio.aws.codebuild.model.ReportType] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    reportGroupArn: Optional[NonEmptyString] = Optional.Absent,
    executionId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.codebuild.model.ReportStatusType] =
      Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    expired: Optional[Timestamp] = Optional.Absent,
    exportConfig: Optional[zio.aws.codebuild.model.ReportExportConfig] =
      Optional.Absent,
    truncated: Optional[WrapperBoolean] = Optional.Absent,
    testSummary: Optional[zio.aws.codebuild.model.TestReportSummary] =
      Optional.Absent,
    codeCoverageSummary: Optional[
      zio.aws.codebuild.model.CodeCoverageReportSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.Report = {
    import Report.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Report
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        reportGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.reportGroupArn)
      .optionallyWith(executionId.map(value => value: java.lang.String))(
        _.executionId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(expired.map(value => Timestamp.unwrap(value): Instant))(
        _.expired
      )
      .optionallyWith(exportConfig.map(value => value.buildAwsValue()))(
        _.exportConfig
      )
      .optionallyWith(truncated.map(value => value: java.lang.Boolean))(
        _.truncated
      )
      .optionallyWith(testSummary.map(value => value.buildAwsValue()))(
        _.testSummary
      )
      .optionallyWith(codeCoverageSummary.map(value => value.buildAwsValue()))(
        _.codeCoverageSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Report.ReadOnly =
    zio.aws.codebuild.model.Report.wrap(buildAwsValue())
}
object Report {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Report] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Report =
      zio.aws.codebuild.model.Report(
        arn.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        reportGroupArn.map(value => value),
        executionId.map(value => value),
        status.map(value => value),
        created.map(value => value),
        expired.map(value => value),
        exportConfig.map(value => value.asEditable),
        truncated.map(value => value),
        testSummary.map(value => value.asEditable),
        codeCoverageSummary.map(value => value.asEditable)
      )
    def arn: Optional[NonEmptyString]
    def `type`: Optional[zio.aws.codebuild.model.ReportType]
    def name: Optional[String]
    def reportGroupArn: Optional[NonEmptyString]
    def executionId: Optional[String]
    def status: Optional[zio.aws.codebuild.model.ReportStatusType]
    def created: Optional[Timestamp]
    def expired: Optional[Timestamp]
    def exportConfig
        : Optional[zio.aws.codebuild.model.ReportExportConfig.ReadOnly]
    def truncated: Optional[WrapperBoolean]
    def testSummary
        : Optional[zio.aws.codebuild.model.TestReportSummary.ReadOnly]
    def codeCoverageSummary
        : Optional[zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.codebuild.model.ReportType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getReportGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportGroupArn", reportGroupArn)
    def getExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getExpired: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expired", expired)
    def getExportConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ReportExportConfig.ReadOnly
    ] = AwsError.unwrapOptionField("exportConfig", exportConfig)
    def getTruncated: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("truncated", truncated)
    def getTestSummary: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.TestReportSummary.ReadOnly
    ] = AwsError.unwrapOptionField("testSummary", testSummary)
    def getCodeCoverageSummary: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly
    ] = AwsError.unwrapOptionField("codeCoverageSummary", codeCoverageSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Report
  ) extends zio.aws.codebuild.model.Report.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val `type`: Optional[zio.aws.codebuild.model.ReportType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codebuild.model.ReportType.wrap(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val reportGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportGroupArn())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val executionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => value: String)
    override val status: Optional[zio.aws.codebuild.model.ReportStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codebuild.model.ReportStatusType.wrap(value))
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val expired: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expired())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val exportConfig
        : Optional[zio.aws.codebuild.model.ReportExportConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportConfig())
        .map(value => zio.aws.codebuild.model.ReportExportConfig.wrap(value))
    override val truncated: Optional[WrapperBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => value: WrapperBoolean)
    override val testSummary
        : Optional[zio.aws.codebuild.model.TestReportSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSummary())
        .map(value => zio.aws.codebuild.model.TestReportSummary.wrap(value))
    override val codeCoverageSummary
        : Optional[zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeCoverageSummary())
        .map(value =>
          zio.aws.codebuild.model.CodeCoverageReportSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Report
  ): zio.aws.codebuild.model.Report.ReadOnly = new Wrapper(impl)
}
